<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Load PHPMailer
require 'vendor/autoload.php';

try {
    // Step 1: Fetch data from the API
    $curl = curl_init();
    curl_setopt_array($curl, array(
        // CURLOPT_URL => 'https://crud.activated.digital/app/api/v1/forms',
        CURLOPT_URL => 'https://crud.activated.digital/app/api/v1/forms/25/submissions',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'X-Api-Key: 0iEij0sc2YemLlG9BP9r2wfw8CdHGOUZ2aETsQ2T'
        ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);

    if (!$response) {
        throw new Exception('Failed to fetch data from API.');
    }

    $data = json_decode($response, true);
    if (!is_array($data)) {
        throw new Exception('Invalid data format received from API.');
    }

    // Step 2: Process the data
    $todayDateString = (new DateTime())->format('Y-m-d');
    $processedData = array_filter(array_map(function ($submission) use ($todayDateString) {
        if (isset($submission['created_at']) && 
            (new DateTime('@' . $submission['created_at']))->format('Y-m-d') === $todayDateString &&
            isset($submission['answers']) && is_array($submission['answers'])) {

            $processed = array_reduce($submission['answers'], function ($map, $answer) {
                $map[$answer['label']] = $answer['answer'];
                return $map;
            }, []);

            $processed['created_at'] = (new DateTime('@' . $submission['created_at']))->format('Y-m-d H:i:s');
            $processed['form_id'] = $submission['form_id'] ?? null;
            $processed['hashId'] = $submission['hashId'] ?? null;
            $processed['id'] = $submission['id'] ?? null;
            $processed['ip'] = $submission['ip'] ?? null;
            $processed['new'] = $submission['new'] ?? null;
            $processed['number'] = $submission['number'] ?? null;

            return $processed;
        }
        return null;
    }, $data));

    // Step 3: Create the CSV file
    $tempCsvPath = sys_get_temp_dir() . DIRECTORY_SEPARATOR . 'submissions.csv';
    $output = fopen($tempCsvPath, 'w');
    if (!$output) {
        throw new Exception('Failed to open temporary file for writing.');
    }

    // Add BOM for UTF-8 compatibility
    fprintf($output, chr(0xEF) . chr(0xBB) . chr(0xBF));

    // Define CSV headers
    $headers = [
        'שם פרטי', 'טלפון', 'דואר אלקטרוני', 'טקסט חופשי', 
        'אישור חומר פרסומי', 'Source', 'תשובה מCRM WebService', 
        'Medium', 'Campaign', 'Term', 'Content', 'pmark', 
        'p_remark', 'p_arg1', 'p_place', 'p_interest_name', 
        'p_adv_cahnnel_name', 'p_future_user', 'created_at', 'form_id', 'hashId', 'id', 'ip', 'new', 'number'
    ];

    fputcsv($output, $headers);

    foreach ($processedData as $entry) {
        $row = array_map(function ($header) use ($entry) {
            return $entry[$header] ?? '';
        }, $headers);
        fputcsv($output, $row);
    }

    fclose($output);

    // Step 4: Send the CSV file via email
    $mail = new PHPMailer(true);
    $mail->isSMTP();
    $mail->Host = 'email-smtp.us-east-1.amazonaws.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'AKIA5MKWZBHT7R62SR5K';  
    $mail->Password = 'BGZrUnCvoLfob+iTgMspvPhgPMrGaxiZvJzv4HC8QLHI'; 
    $mail->SMTPSecure = 'tls';
    $mail->Port = 587;

    $mail->setFrom('leads@activated.digital', 'Activated');
    $mail->addAddress('nikita@activated.digital');
    $mail->Subject = 'Submissions CSV File';
    $mail->Body = 'Please find the attached submissions CSV file.';
    $mail->addAttachment($tempCsvPath, 'submissions.csv');

    $mail->send();
    unlink($tempCsvPath);

    echo 'CSV file created and sent via email successfully.';
} catch (Exception $e) {
    http_response_code(500);
    echo 'Error: ' . $e->getMessage();
}
